<?php

/**
 * Handel API Callbacks
 *
 * @since 1.0.0
 *
 */

if (!class_exists('CG_SM_APIController')) {
    class CG_SM_APIController
    {
        public function __construct()
        {
            add_action('rest_api_init', [$this, 'register_api']);
        }

        public function register_api()
        {
            register_rest_route('cgsm', 'sync-site', array(
                'methods' => 'POST',
                'callback' => [$this, 'fetch_site_data'],
            ));
        }

        public function fetch_site_data($data)
        {
			if (false === function_exists('get_core_updates')) {
                require_once(ABSPATH . 'wp-admin/includes/update.php');
            }
			if (!function_exists('wp_check_php_version')) {
                include_once ABSPATH . '/wp-admin/includes/misc.php';
            }
            $site_data = [];
            $req_key = $data['key'] ?? '';
            $req_client_url = $data['host_site'] ?? '';
			
            $this_settings = get_option('cg_smc_settings');
            $this_key = $this_settings['key'] ?? '';

			try{
				if ($req_key != "" && $req_key == $this_key) {

					$CG_SM_HealthController = new CG_SM_HealthController();
					$site_data = $CG_SM_HealthController->get_site_info();
				}
			}catch(Exception $e){
				$site_data = $e->getMessage();
			}
            return $site_data;
        }
    }
}

if (class_exists('CG_SM_APIController')) {
    $CG_SM_APIController = new CG_SM_APIController();
}
