<?php

/**
 * Handel ajax requests
 * @since 1.0.0
 */

if (!class_exists('CG_SM_AjaxController')) {
    class CG_SM_AjaxController
    {
        public function __construct()
        {
            add_action('wp_ajax_cg_sm_connect_site_ajax', array($this, 'connect_site'));
            add_action('wp_ajax_nopriv_cg_sm_connect_site_ajax', array($this, 'connect_site'));
        }

        public function connect_site()
        {
            $resp = array();
            if (wp_verify_nonce($_POST['cg_sm_connect_site_submit_nonce'], 'cg_sm_connect_site_nonce')) {

                $host_site = $_POST['host_site'] ?? '';
                $site_key = $_POST['key'] ?? '';

                if ($host_site != "" && $site_key != "") {

                    update_option('cg_smc_settings', array('site' => $host_site, 'key' => $site_key));
                    $CG_SM_HealthController = new CG_SM_HealthController();
                    $site_info_data = $CG_SM_HealthController->get_site_info();
					error_log(json_encode($site_info_data));
                    $resp_data = wp_remote_post($host_site . '/index.php/wp-json/cgsm/sites', array(
                        'body'    => json_encode(array(
                            'key'        => $site_key,
                            'client_url' => home_url(),
                            'site_info' => $site_info_data,
							'site_title' => get_bloginfo('name')
                        )),
                        'headers'     => [
                            'Content-Type' => 'application/json',
                        ],
                    ));

                    if (is_wp_error($resp_data)) {
                        $resp['status'] = 500;
// 						error_log($resp_data->get_error_message());
                        $resp['message'] = $resp_data->get_error_message();
                        update_option('cg_smc_site_status', 'disconnected');
                    } else {
                        $response = rest_ensure_response(json_decode(wp_remote_retrieve_body($resp_data)));
                        $has_key = $response->data ?? false;
// 						error_log($has_key);
                        if ($has_key) {
                            $resp['status'] = 200;
                            $resp['message'] = __('Site Key is Valid', 'cg-site-manager');

                            update_option('cg_smc_site_status', 'connected');
                        } else {
                            $resp['status'] = 400;
                            $resp['message'] = __('Site Key Invalid', 'cg-site-manager');
							$resp['data'] = $response;
							$resp['args'] = $resp_data;
                            update_option('cg_smc_site_status', 'disconnected');
                        }
                    }
                } else {
                    $resp['status'] = 400;
                    $resp['message'] = __('Parameter Missing', 'cg-site-manager');
                }
            } else {
                $resp['status'] = 400;
                $resp['message'] = __('Invalid nonce!', 'cg-site-manager');
            }
            wp_send_json($resp);
            exit();
        }
    }
}

if (class_exists('CG_SM_AjaxController')) {
    $CG_SM_AjaxController = new CG_SM_AjaxController();
}
