<?php

/**
 * Handel Health Methods
 *
 * @since 1.0.0
 *
 */

if (!class_exists('CG_SM_HealthController')) {
    class CG_SM_HealthController
    {
        public function __construct() {}

        public function get_site_info()
        {
            $plugin_update = $this->plugin_update();
            $site_health = (float) $this->site_health();
            $site_score = $this->site_score();
            $site_issues = $this->get_site_issues();
            $site_security_status = (float) $this->check_site_security_status();

            $risk_status_index = max(array($site_security_status, $site_health));
            $risk_status = "No Data ";
            if($risk_status_index == 0){
                $risk_status = 'Good';
            }else if($risk_status_index == 1){
                $risk_status = 'Minor';
            }else if($risk_status_index == 2){
                $risk_status = 'Critical';
            }

            $site_services = $this->check_services_maintained() ? 'Maintained' : 'Not maintained';

            $site_info_data = array(
                'plugin_update' => $plugin_update,
                'health' => $site_health,
                'site_score' => $site_score,
                'issues' => $site_issues,
                'security' => $site_security_status,
                'risk' => $risk_status,
                'services' => $site_services
            );
//             update_option(' ', $site_info_data);
            return $site_info_data;
        }

        public function check_services_maintained(){
            return is_plugin_active('wp-health/wp-health.php');
        }

        private function site_score()
        {
            $site_url = home_url();
            $api_url = "https://www.googleapis.com/pagespeedonline/v5/runPagespeed?url=" . $site_url . "&strategy=desktop&key=AIzaSyCJBWmLP5Mz8uO2_WY1zqCL2QeeQWybx08";
            $response = wp_remote_get($api_url,['timeout' => 6000]);
            if (is_wp_error($response)) {
				error_log($response->get_error_message());
                return; //$response->get_error_message();
            } else {
                $resp = rest_ensure_response(json_decode(wp_remote_retrieve_body($response), true));
                return $resp->data['lighthouseResult']['categories']['performance']['score'] ?? 'Unknown';
            }
        }


        private function get_site_issues(){
            $issues_count = [];
            $site_health = new WP_Site_Health();
            $tests = $site_health->get_tests();
            foreach ($tests['direct'] as $test) {
                if (is_string($test['test'])) {
                    $test_function = sprintf(
                        'get_test_%s',
                        $test['test']
                    );
                    $health_test_result = call_user_func(array($site_health, $test_function));

                    if(isset($health_test_result['status']) && $health_test_result['status'] != 'good'){
                        $issues_count[] = $health_test_result['label'] ?? 'Unknown';
                    }
                }
            }
            return (is_array($issues_count) && !empty($issues_count)) ? count($issues_count) : 0;
        }


       private function check_site_security_status() {
            global $wp_version, $wpdb;
        
            // Security status tracking
            $critical_issues = [];
            $minor_issues = [];
        
            // Check WordPress Version
            $wp_version_supported = version_compare($wp_version, '6.0', '>=');
            if (!$wp_version_supported) {
                $critical_issues[] = "Outdated WordPress version ($wp_version).";
            }
        
            // Check PHP Version
            $php_version_supported = version_compare(PHP_VERSION, '7.4', '>=');
            if (!$php_version_supported) {
                $critical_issues[] = "Unsupported PHP version (" . PHP_VERSION . ").";
            }
        
            // Check File Permissions
            $files = [ABSPATH . 'wp-config.php', ABSPATH . 'index.php', ABSPATH . '.htaccess'];
            foreach ($files as $file) {
                if (file_exists($file)) {
                    $permissions = substr(sprintf('%o', fileperms($file)), -4);
                    if ($permissions !== '0644' && $permissions !== '0600') {
                        $minor_issues[] = "File permissions for $file are not secure ($permissions).";
                    }
                }
            }
        
            // Check Database Prefix
            if ($wpdb->prefix === 'wp_') {
                $minor_issues[] = "Default database prefix 'wp_' is being used.";
            }
        
            // Check Salt Keys
            $config = file_get_contents(ABSPATH . 'wp-config.php');
            $keys = ['AUTH_KEY', 'SECURE_AUTH_KEY', 'LOGGED_IN_KEY', 'NONCE_KEY'];
            foreach ($keys as $key) {
                if (!strpos($config, $key)) {
                    $critical_issues[] = "Security key $key is not set in wp-config.php.";
                }
            }
        
            // Check Admin Username
            if (username_exists('admin')) {
                $critical_issues[] = "Default admin username 'admin' exists. Consider removing it.";
            }
        
            // Check SSL
            if (!is_ssl()) {
                $minor_issues[] = "SSL is not enabled.";
            }
        
            // Check Directory Browsing
            $htaccess = ABSPATH . '.htaccess';
            if (file_exists($htaccess) && strpos(file_get_contents($htaccess), 'Options -Indexes') === false) {
                $minor_issues[] = "Directory browsing is enabled. Add 'Options -Indexes' to .htaccess to disable it.";
            }
        
            // Determine overall status
            if (!empty($critical_issues)) {
                return 2;//"Critical";
            } elseif (!empty($minor_issues)) {
                return 1;//"Minor";
            } else {
                return 0;//"Good";
            }
        }        

        private function site_health()
        {
            $results = [];
            $site_status = array(
                0 => 0,
                1 => 0,
                2 => 0,
                // 'good' => 0,
                // 'should_be_imporoved' => 0,
                // 'critical' => 0,
            );
            $site_health = new WP_Site_Health();
            $tests = $site_health->get_tests();
            foreach ($tests['direct'] as $test) {
                if (is_string($test['test'])) {
                    $test_function = sprintf(
                        'get_test_%s',
                        $test['test']
                    );
                    $results[] = call_user_func(array($site_health, $test_function));
                }
            }
            foreach ($results as $result) {
                if ('critical' === $result['status']) {
                    ++$site_status['critical'];
                } elseif ('recommended' === $result['status']) {
                    ++$site_status['should_be_imporoved'];
                } else {
                    ++$site_status['good'];
                }
            }
            $maxValue = max($site_status);
            $maxKey = array_search($maxValue, $site_status);
            return $maxKey;
        }

        private function plugin_update()
        {
            $resp = '';
            $all_plugins = get_plugins();
            $update_plugins = get_site_transient('update_plugins');
            $plugins_to_update = [];
            if (!empty($update_plugins->response)) {
                foreach ($update_plugins->response as $plugin_file => $plugin_data) {
                    if (isset($all_plugins[$plugin_file])) {
                        $plugins_to_update[$plugin_file] = $all_plugins[$plugin_file];
                        $plugins_to_update[$plugin_file]['new_version'] = $plugin_data->new_version;
                    }
                }
            }
            if (empty($plugins_to_update)) {
                $resp = 0;
            } else {
                $resp = count($plugins_to_update);
            }
            return $resp;
        }
    }
}

if (class_exists('CG_SM_HealthController')) {
    $CG_SM_HealthController = new CG_SM_HealthController();
}
