<?php

/**
 * Handel main static functions
 *
 * @since 1.0.0
 *
 */

if (!class_exists('CG_SM_MainController')) {
    class CG_SM_MainController
    {
        public $version;

        public function __construct()
        {
            $plugin_data = get_file_data(CG_SM_FILE, array('Version' => 'Version'), false);
            $plugin_version = $plugin_data['Version'];
            $this->version = $plugin_version;
            add_action('admin_menu', [$this, 'poll_settings']);
            add_action('template_redirect', [$this, 'signin_remotely']);

            // Updates
            add_filter('plugins_api', [$this, 'view_version_details'], 1, 3);
            add_filter('site_transient_update_plugins', [$this, 'push_update'], 1);
        }

        public function poll_settings(): void
        {
            add_submenu_page(
				'options-general.php',
                'Site Manager',
                'Site Manager',
                'manage_options',
                'site-manager-sites',
                [$this, 'site_manager_client_settings'],
                '',
      
            );
        }

        private function rw_hash($string, $encrypt = true)
        {
            $encrypt_method = "AES-256-CBC";
            $secret_key = "AA74CDCC2BBRT935136HH7B63C27"; // user define private key
            $secret_iv = "RwS3cr3t"; // user define secret key
            $key = hash("sha256", $secret_key);
            $iv = substr(hash("sha256", $secret_iv), 0, 16); // sha256 is hash_hmac_algo
            if ($encrypt) {
                $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
                $output = base64_encode($output);
            } else {
                $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
            }
            return $output;
        }

        public function signin_remotely()
        {
            if (isset($_GET['cgsmc']) and $_GET['cgsmc'] != "") {
                $cgsmc_encrypt = $_GET['cgsmc'];
                $admin_creds = explode(':', $this->rw_hash($cgsmc_encrypt, false));
                $username = $admin_creds[0] ?? '';
                $password = $admin_creds[1] ?? '';

                $user = get_user_by('login', $username);

                if ($user && wp_check_password($password, $user->data->user_pass, $user->ID)) {
                    $creds = array(
                        'user_login'    => $username,
                        'user_password' => $password,
                        'remember'      => true
                    );

                    error_log(json_encode($creds));

                    $user = wp_signon($creds, false);

                    if (is_wp_error($user)) {
                        error_log($user->get_error_message());
                    } else {
                        wp_set_current_user($user->ID, $user->user_login);
                        wp_set_auth_cookie($user->ID);
                        do_action('wp_login', $user->ID, $user);

                        wp_redirect(admin_url());
                        exit;
                    }
                }

                wp_redirect(home_url());
                exit;
            }
        }

        public function site_manager_client_settings()
        {
            require CG_SM_PATH . '/views/admin/settings.php';
        }

        public function view_version_details($res, $action, $args)
        {
            if ($args->slug !== 'cg-site-manager-client') return $res;
            $res = new stdClass();
            $res->name = 'Site Manager Client';
            $res->slug = 'cg-site-manager-client';
            $res->path = 'cg-site-manager-client/cg-site-manager-client.php';
            $changelog = $this->plugin_check_request();
            $res->sections = json_decode(json_encode($changelog->sections), true);
            $res->version = $changelog->latest_version;
            $res->download_link = $changelog->download_url;
            $res->banners = array(
                'high' => $changelog->banners->high
            );
            return $res;
        }

        public function push_update($transient)
        {
            $update_check = get_option('cgsc_update_check', time());
            $update_info = get_option('cgsc_update_info', []);

            if (empty($transient->checked)) {
                return $transient;
            }

            if ($update_check >= time() && !empty($update_info)) {
                $remote = $update_info;
            } else {
                update_option('cgsc_update_check', time() + 3600);

                $remote = $this->plugin_check_request();
                update_option('cgsc_update_info', $remote);
            }
            
            if (
                $remote
                && version_compare($this->version, $remote->version, '<')
                && version_compare($remote->requires, get_bloginfo('version'), '<')
                && version_compare($remote->requires_php, PHP_VERSION, '<')
            ) {
                $res = new stdClass();
                $res->slug = $remote->slug;
                $res->plugin = 'cg-site-manager-client/cg-site-manager-client.php'; // it could be just YOUR_PLUGIN_SLUG.php if your plugin doesn't have its own directory
                $res->new_version = $remote->version;
                $res->tested = $remote->tested;
                $res->package = $remote->download_url;
                $transient->response[$res->plugin] = $res;
                // $transient->checked[$res->plugin] = $remote->version;
            }


            return $transient;
        }

        public function plugin_check_request()
        {
            $access = wp_remote_get('https://wprecap.rrulb.com/wp-content/plugins/cg-site-manager/client-add-on/site-manager-update.json', array('timeout' => 10,   'headers' => array('Accept' => 'application/json')));
            if (! is_wp_error($access) && 200 === wp_remote_retrieve_response_code($access)) {
                $result = json_decode(wp_remote_retrieve_body($access));
                return $result;
            }
            return [];
        }
    }
}

if (class_exists('CG_SM_MainController')) {
    $CG_SM_MainController = new CG_SM_MainController();
}
