<?php

/**
 * Plugin Name: Site Manager Client
 * Author: Blurr
 * Description: Effortlessly manage multiple WordPress sites from a single dashboard. Ideal for agencies and developers, this plugin offers centralized control over updates, plugins, themes, and more, streamlining site management.
 * Version: 1.0.5
 */

if (!defined('ABSPATH')) {
    exit();
}

if (!class_exists('CG_SM')) {
    class CG_SM
    {
        public function __construct()
        {
            $this->define_constants();
            add_action('wp_enqueue_scripts', array($this, 'static_assets'));
            add_action('admin_enqueue_scripts', array($this, 'admin_static_assets'));
            require CG_SM_PATH . '/app/AjaxController.php';
            require CG_SM_PATH . '/app/MainController.php';
            require CG_SM_PATH . '/app/HealthController.php';
            require CG_SM_PATH . '/app/APIController.php';
        }

        /**
         * Define all required constants `CG_SM_PATH` or `CG_SM_URL`
         * @return void
         * @since 1.0.0
         */
        public function define_constants(): void
        {
            define('CG_SM_PATH', __DIR__);
            define('CG_SM_FILE', __FILE__);
            define('CG_SM_URL', plugin_dir_url(CG_SM_FILE));
        }

        public function static_assets(): void
        {
            wp_enqueue_script('jquery');
        }

        public function admin_static_assets(): void
        {
            wp_enqueue_script('cg-sm-admin', CG_SM_URL . '/static/js/admin-script.js', array(), wp_rand());
            wp_enqueue_style('cg-sm-admin', CG_SM_URL . '/static/css/admin-style.css', array(), wp_rand());
            wp_localize_script('cg-sm-admin', 'cg_sm_admin_constants', array(
                'ajax_url' => admin_url('admin-ajax.php')
            ));
        }
    }
}

if (class_exists('CG_SM')) {
    $CG_SM = new CG_SM();
}

function cgsm_encrypt_decrypt($string, $action = 'encrypt')
{
    $encrypt_method = "AES-256-CBC";
    $secret_key = 'AA74CDCC2BBRT935136HH7B63C27'; // user define private key
    $secret_iv = '5fgf5HJ5g27'; // user define secret key
    $key = hash('sha256', $secret_key);
    $iv = substr(hash('sha256', $secret_iv), 0, 16); // sha256 is hash_hmac_algo
    if ($action == 'encrypt') {
        $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
        $output = base64_encode($output);
    } else if ($action == 'decrypt') {
        $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
    }
    return $output;
}