const CGSM_SEND = (
  method = "POST",
  req_data = {},
  redirect = false,
  loader_target = null,
  is_form = false,
  debug = false
) => {
  let target_is_jq = false;
  if (loader_target != null && loader_target instanceof jQuery) {
    target_is_jq = true;
  }
  let loader_tag = target_is_jq ? loader_target : jQuery(loader_target);

  // console.log(loader_tag);
  loader_tag.addClass("processing");
  const CGSM_PARAMS = {
    url: cg_sm_admin_constants.ajax_url,
    type: method,
    data: req_data,
  };
  if (is_form) {
    CGSM_PARAMS["cache"] = false;
    CGSM_PARAMS["processData"] = false;
    CGSM_PARAMS["contentType"] = false;
  }
  jQuery
    .ajax(CGSM_PARAMS)
    .done((res) => {
      loader_tag.removeClass("processing");
      if (debug) {
        console.log(res);
      }
      if (redirect != false) {
        if (typeof redirect == "boolean" && redirect == true) {
          window.location.reload();
        } else {
          window.location.href = redirect;
        }
      }
    })
    .fail((err) => {
      loader_tag.removeClass("processing");
      if (debug) {
        console.log(err);
      }
    });
};

jQuery(document).on("submit", "#cg_smc_settings_form", function (e) {
  e.preventDefault();
  let this_form = jQuery(this);
  let this_form_data = new FormData(this_form.get(0));
  this_form_data.append("action", "cg_sm_connect_site_ajax");
  CGSM_SEND("POST", this_form_data, true, this_form, true, false);
});

jQuery(document).on("click", "#edit_keys_btn", function (e) {
  e.preventDefault();
  let form = jQuery("#cg_smc_settings_form");
  form.find("#cg_smc_host_site").prop("readonly", false).val("");
  form.find("#cg_smc_key").prop("readonly", false).val("");
  jQuery(this).hide();
  form.find("[type=submit]").show();
});
